package com.agilex.healthcare.veteranappointment.clientapi;

import com.agilex.healthcare.utility.NullChecker;
import org.w3c.dom.Document;

import javax.ws.rs.client.WebTarget;
import java.net.URI;

public class MobileHealthClientTestVersion {
	private static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MobileHealthClientTestVersion.class);
	private JerseyClientHandle jerseyHandle = null;

	public MobileHealthClientTestVersion() {
		jerseyHandle = new JerseyClientHandle();
	}

	public JerseyClientHandle getJerseyClientHandle() {
		return jerseyHandle;
	}

	public javax.ws.rs.client.Client getJerseyClient() {
		return getJerseyClientHandle().getJerseyClient();
	}

	public PatientResourceClient getPatientResourceClient() {
		return new PatientResourceClient(this.getJerseyClientHandle());
	}

	public Document getAsXml(URI uri) {
		if (NullChecker.isNullish(uri))
			throw new IllegalArgumentException();
		return getAsXml(uri.toString());
	}

	public Document getAsXml(String uri) {
		if (NullChecker.isNullish(uri))
			throw new IllegalArgumentException();
		WebTarget resource = jerseyHandle.resource(uri);
		logger.debug("GET " + uri.toString());
		Document result = resource.request().get(Document.class);
		return result;
	}

}
